<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/Testimonianze.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatoreTestimonianze = new Testimonianze($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $visualizzatoreTestimonianze = new Testimonianze($geecomDb, filter_input(INPUT_GET, "id"));
    }

    switch ($operazione) {
        case 'crea':
            $visualizzatoreTestimonianze->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreTestimonianze->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $visualizzatoreTestimonianze->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreTestimonianze->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $visualizzatoreTestimonianze->setElementiPerRiga(filter_input(INPUT_POST,"elementiPerRiga",FILTER_SANITIZE_NUMBER_INT));
            $mostraImmagini = (isset($_POST["mostraImmagini"]) && $_POST["mostraImmagini"]=="si") ? "si" : "no";
            $visualizzatoreTestimonianze->setMostraImmagini($mostraImmagini);
            $visualizzatoreTestimonianze->crea();
            header("Location: ../creaTestimonianze.php?id={$visualizzatoreTestimonianze->getId()}&status=200");
            break;
        case 'modifica':
            $visualizzatoreTestimonianze->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreTestimonianze->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $visualizzatoreTestimonianze->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $visualizzatoreTestimonianze->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $visualizzatoreTestimonianze->setElementiPerRiga(filter_input(INPUT_POST,"elementiPerRiga",FILTER_SANITIZE_NUMBER_INT));
            $mostraImmagini = (isset($_POST["mostraImmagini"]) && $_POST["mostraImmagini"]=="si") ? "si" : "no";
            $visualizzatoreTestimonianze->setMostraImmagini($mostraImmagini);
            $visualizzatoreTestimonianze->modifica();
            header("Location: ../creaTestimonianze.php?id={$visualizzatoreTestimonianze->getId()}&status=250");
            break;
        case 'elimina':
            $visualizzatoreTestimonianze->elimina();
            echo "ok";
            break;
        case 'duplica':
            $visualizzatoreTestimonianze->caricaDatiDalDatabase();
            $idNuovaForm = $visualizzatoreTestimonianze->duplica();
            header("Location: ../creaTestimonianze.php?id={$idNuovaForm}&status=260");
            break;
        case 'creaElemento':
            $nome   = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_ADD_SLASHES);
            $autore = filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES);
            $ruolo  = filter_input(INPUT_POST, "ruolo",FILTER_SANITIZE_STRING);
            $visualizzatoreTestimonianze->creaElemento($nome,$autore,$ruolo);
            echo "ok";
            break;
        case 'spostaElemento':
            $visualizzatoreTestimonianze->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome        = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $autore      = filter_input(INPUT_POST,"autore",FILTER_SANITIZE_ADD_SLASHES);
            $ruolo       = filter_input(INPUT_POST,"ruolo",FILTER_SANITIZE_STRING);
            $azienda     = filter_input(INPUT_POST,"azienda",FILTER_SANITIZE_STRING);
            $email       = filter_input(INPUT_POST,"email",FILTER_SANITIZE_STRING);
            $descrizione = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $stelle      = filter_input(INPUT_POST,"stelle",FILTER_SANITIZE_NUMBER_INT);
            $consensoPubblicazione = (isset($_POST["consensoPubblicazione"]) && $_POST["consensoPubblicazione"]=="si") ? "si" : "no";
                    
            $visualizzatoreTestimonianze->modificaElemento($idElemento,$nome, $autore, $ruolo, $azienda,$email,$descrizione,$stelle,$consensoPubblicazione);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'duplicaElemento':
            $idElemento = filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_STRING);
                    
            $idNuovoElemento = $visualizzatoreTestimonianze->duplicaElemento($idElemento);
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=220");
            break;
        case 'stampaElementi':
            $visualizzatoreTestimonianze->stampaElementi();
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $visualizzatoreTestimonianze->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':    
            $idElemento  = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $visualizzatoreTestimonianze->cambiaImmagineElemento($idElemento,"");
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $visualizzatoreTestimonianze->cambiaImmagineElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $visualizzatoreTestimonianze->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
